#include <iostream>
#include <vector>

using namespace std;

int izracunaj_preseke(const vector<int>& niz) {
    int presek = 0;
    for (size_t i = 0; i + 1 < niz.size(); i++) {
        if (niz[i] > niz[i + 1]) {
            presek++;
        }
    }
    return presek;
}

int azuriraj_preseke(vector<int>& niz, int presek, int a, int b) {
    // Koristimo samo relevantne pozicije koje mogu uticati na presek
    int stari = 0, novi = 0;

    // Pozicije koje treba proveriti pre swap-a
    if (a > 0 && niz[a-1] > niz[a]) stari++;
    if (a < niz.size() - 1 && niz[a] > niz[a+1]) stari++;
    if (b > 0 && niz[b-1] > niz[b]) stari++;
    if (b < niz.size() - 1 && niz[b] > niz[b+1]) stari++;

    // Swap operacija
    swap(niz[a], niz[b]);

    // Pozicije koje treba proveriti posle swap-a
    if (a > 0 && niz[a-1] > niz[a]) novi++;
    if (a < niz.size() - 1 && niz[a] > niz[a+1]) novi++;
    if (b > 0 && niz[b-1] > niz[b]) novi++;
    if (b < niz.size() - 1 && niz[b] > niz[b+1]) novi++;

    // Ažuriraj broj preseka
    return presek - stari + novi;
}

int main() {
    cin.tie(nullptr);

    int n, q, i, j, presek;
    cin >> n >> q;
    vector<int> niz(n);

    for (i = 0; i < n; i++) {
        cin >> niz[i];
    }

    vector<pair<int, int>> upiti(q);
    for (int i = 0; i < q; i++) {
        cin >> upiti[i].first >> upiti[i].second;
    }

    // Izracunaj pocetni presek
    presek = izracunaj_preseke(niz);
    cout << presek << "\n";

    // Obradi svaki upit
    for (const auto& par : upiti) {
        i = par.first - 1; // Prilagoditi na 0-indeksiranje
        j = par.second - 1; // Prilagoditi na 0-indeksiranje

        // Ažuriraj presek
        presek = azuriraj_preseke(niz, presek, i, j);
        cout << presek << "\n";
    }

    return 0;
}